/*
Navicat MySQL Data Transfer

Source Server         : dataWareHouse
Source Server Version : 50557
Source Host           : bi.ripit.cl:3306
Source Database       : biripit_pre_dw_silob

Target Server Type    : MYSQL
Target Server Version : 50557
File Encoding         : 65001

Date: 2017-10-02 15:47:57
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for PDW_analisis
-- ----------------------------
DROP TABLE IF EXISTS `PDW_analisis`;
CREATE TABLE `PDW_analisis` (
  `WID_analisis` int(11) NOT NULL AUTO_INCREMENT,
  `WID_resumen_mensual_ingreso` int(11) NOT NULL,
  `id_analisis` int(11) NOT NULL,
  `id_tipo_analisis` int(11) NOT NULL,
  `variacion` varchar(50) DEFAULT NULL,
  `id_muestra` int(11) NOT NULL,
  `cod_norma_val` int(11) DEFAULT NULL,
  `cod_unidad` int(6) DEFAULT NULL,
  `cod_acreditacion` int(6) DEFAULT NULL,
  `id_envase` int(6) DEFAULT NULL,
  `id_set` int(11) DEFAULT NULL,
  `id_cartacontrol` int(11) DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_analisis`),
  UNIQUE KEY `ind_id_analisis_1` (`id_analisis`) USING BTREE,
  KEY `fk_analis_resum_ing` (`WID_resumen_mensual_ingreso`) USING BTREE,
  KEY `ind_idMue_ana` (`id_muestra`) USING BTREE,
  KEY `ind_idTana_ana` (`id_tipo_analisis`) USING BTREE,
  CONSTRAINT `PDW_analisis_ibfk_1` FOREIGN KEY (`WID_resumen_mensual_ingreso`) REFERENCES `DW_resumen_mensual_ingresos` (`WID_resumen_mensual_ingreso`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=262141 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_años
-- ----------------------------
DROP TABLE IF EXISTS `PDW_años`;
CREATE TABLE `PDW_años` (
  `WID_año` int(11) NOT NULL AUTO_INCREMENT,
  `año` int(11) NOT NULL,
  PRIMARY KEY (`WID_año`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_area
-- ----------------------------
DROP TABLE IF EXISTS `PDW_area`;
CREATE TABLE `PDW_area` (
  `WID_area` int(11) NOT NULL AUTO_INCREMENT,
  `id_area` int(11) NOT NULL,
  `area` varchar(100) NOT NULL,
  `last_update` datetime NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_area`),
  UNIQUE KEY `ind_id_area` (`id_area`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_clientes
-- ----------------------------
DROP TABLE IF EXISTS `PDW_clientes`;
CREATE TABLE `PDW_clientes` (
  `WID_cliente` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) NOT NULL,
  `razon_social` varchar(1000) DEFAULT NULL,
  `nombre` varchar(1000) DEFAULT NULL,
  `nro_rut` int(9) DEFAULT NULL,
  `dv_rut` char(1) DEFAULT NULL,
  `direccion` varchar(500) DEFAULT NULL,
  `cont_facturacion` varchar(500) DEFAULT NULL,
  `fono_cont` varchar(25) DEFAULT NULL,
  `fono2_cont` varchar(25) DEFAULT NULL,
  `mail_cont` varchar(200) DEFAULT NULL,
  `cod_ciiu` int(11) DEFAULT NULL,
  `cod_status` int(11) DEFAULT NULL,
  `pub_local` tinyint(1) DEFAULT NULL,
  `pub_descrip` tinyint(1) DEFAULT NULL,
  `pub_fecham` tinyint(1) DEFAULT NULL,
  `estado_cl` enum('') DEFAULT NULL,
  `version` int(1) DEFAULT NULL,
  `flag_vigente` tinyint(1) DEFAULT NULL,
  `id_usuario_upin` int(11) DEFAULT NULL,
  `id_usuario_vali` int(11) DEFAULT NULL,
  `update_timestamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `flag_eliminado` tinyint(1) DEFAULT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_cliente`),
  UNIQUE KEY `ind_id_cliente` (`id_cliente`)
) ENGINE=InnoDB AUTO_INCREMENT=4096 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_encuestas
-- ----------------------------
DROP TABLE IF EXISTS `PDW_encuestas`;
CREATE TABLE `PDW_encuestas` (
  `WID_encuesta` int(11) NOT NULL AUTO_INCREMENT,
  `WID_resumen_mensual_encuesta` int(11) NOT NULL,
  `id_encuesta` int(11) NOT NULL,
  `id_pregunta` int(11) NOT NULL,
  `valor_pregunta` tinyint(1) DEFAULT NULL COMMENT 'respuesta pregunta',
  `id_contacto` int(11) DEFAULT NULL,
  `codigo` varchar(10) DEFAULT NULL,
  `fecha` datetime DEFAULT '0000-00-00 00:00:00',
  `area` char(1) DEFAULT NULL,
  `flag_muestreo` tinyint(1) DEFAULT NULL,
  `flag_analisis` tinyint(1) DEFAULT NULL,
  `mejora` text,
  `observacion` text,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_encuesta`),
  KEY `fk_res_enc_dw_enc` (`WID_resumen_mensual_encuesta`) USING BTREE,
  KEY `ind_id_encue` (`id_encuesta`) USING BTREE,
  CONSTRAINT `PDW_encuestas_ibfk_1` FOREIGN KEY (`WID_resumen_mensual_encuesta`) REFERENCES `DW_resumen_mensual_encuestas` (`WID_resumen_mensual_encuesta`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=451 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_fechas
-- ----------------------------
DROP TABLE IF EXISTS `PDW_fechas`;
CREATE TABLE `PDW_fechas` (
  `WID_fecha` int(11) NOT NULL AUTO_INCREMENT,
  `WID_anho` int(4) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`WID_fecha`),
  KEY `fk_mes_fecha_1` (`WID_mes`) USING BTREE,
  KEY `fk_anho_fecha_2` (`WID_anho`) USING BTREE,
  KEY `fk_sem_fecha_3` (`WID_semestre`) USING BTREE,
  KEY `ind_fecha` (`fecha`) USING BTREE,
  CONSTRAINT `fk_anho_fecha` FOREIGN KEY (`WID_anho`) REFERENCES `PDW_meses` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_fechas_ibfk_2` FOREIGN KEY (`WID_mes`) REFERENCES `DW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_fechas_ibfk_3` FOREIGN KEY (`WID_semestre`) REFERENCES `DW_meses` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18629 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_ingresos`;
CREATE TABLE `PDW_ingresos` (
  `WID_ingreso` int(11) NOT NULL AUTO_INCREMENT,
  `id_ingreso` int(11) NOT NULL,
  `id_tipo_ingreso` int(11) NOT NULL,
  `id_cliente` int(11) NOT NULL,
  `id_dependencia` int(11) NOT NULL,
  `id_usuario_ingreso` int(11) DEFAULT NULL,
  `id_usuario_validacion` int(11) DEFAULT NULL,
  `id_factura` int(11) DEFAULT NULL,
  `nro_ingreso` varchar(100) DEFAULT NULL,
  `raya` char(6) DEFAULT NULL,
  `flag_reemplazado` char(1) DEFAULT NULL,
  `flag_foto_informe` tinyint(1) DEFAULT NULL,
  `flag_carta` tinyint(1) DEFAULT NULL,
  `flag_sma` tinyint(1) DEFAULT NULL,
  `titular_proyecto` varchar(300) DEFAULT NULL,
  `rut_titular` varchar(200) DEFAULT NULL,
  `representante` varchar(300) DEFAULT NULL,
  `rut_representante` varchar(200) DEFAULT NULL,
  `proyecto` varchar(200) DEFAULT NULL,
  `instrumentos` varchar(200) DEFAULT NULL,
  `muestreador` varchar(200) DEFAULT NULL,
  `nro_requerimiento` varchar(100) DEFAULT NULL,
  `fh_validacion` datetime DEFAULT NULL,
  `fecha_ingreso` date DEFAULT NULL,
  `hora_ingreso` time DEFAULT NULL,
  `certificacion_snp` varchar(100) DEFAULT NULL,
  `nro_formulario_snp` varchar(100) DEFAULT NULL,
  `cod_destino_snp` varchar(5) DEFAULT NULL,
  `cod_categoria` int(5) DEFAULT NULL,
  `lugar_descarga` varchar(100) DEFAULT NULL,
  `f_i_muestreo` date DEFAULT NULL,
  `f_muestreo` date DEFAULT NULL,
  `fh_almacenamiento` datetime DEFAULT NULL,
  `h_i_muestreo` time DEFAULT NULL,
  `h_t_muestreo` time DEFAULT NULL,
  `f_i_verificacion` date DEFAULT NULL,
  `f_t_verificacion` date DEFAULT NULL,
  `cont_muestreo` varchar(500) DEFAULT NULL,
  `nro_muestreo` varchar(30) DEFAULT NULL,
  `id_muestreador` int(11) DEFAULT NULL,
  `nro_muestreo2` int(20) DEFAULT NULL,
  `id_muestreador2` int(11) DEFAULT NULL,
  `cod_entrega` int(5) DEFAULT NULL,
  `entidad_m` varchar(200) DEFAULT NULL,
  `flag_limites` tinyint(1) DEFAULT NULL,
  `lugar_muestreo` varchar(1000) DEFAULT NULL,
  `envases_cliente` varchar(100) DEFAULT NULL,
  `coleman_cliente` varchar(100) DEFAULT NULL,
  `otros_bienes_cliente` varchar(500) DEFAULT NULL,
  `fh_informe` datetime DEFAULT NULL,
  `flag_caudal` char(1) DEFAULT NULL,
  `flag_compuesta` char(1) DEFAULT NULL,
  `fh_v_destino0` datetime DEFAULT NULL,
  `fh_s_destino0` datetime DEFAULT NULL,
  `cod_destino1` int(5) DEFAULT NULL,
  `fh_i_destino1` datetime DEFAULT NULL,
  `fh_s_destino1` datetime DEFAULT NULL,
  `cod_destino2` int(5) DEFAULT NULL,
  `fh_i_destino2` datetime DEFAULT NULL,
  `fh_s_destino2` datetime DEFAULT NULL,
  `cod_destino3` int(5) DEFAULT NULL,
  `fh_i_destino3` datetime DEFAULT NULL,
  `fh_s_destino3` datetime DEFAULT NULL,
  `cod_destino4` int(5) DEFAULT NULL,
  `fh_i_destino4` datetime DEFAULT NULL,
  `fh_s_destino4` datetime DEFAULT NULL,
  `cod_destino5` int(5) DEFAULT NULL,
  `nro_fact` varchar(20) DEFAULT NULL,
  `fh_fact` datetime DEFAULT NULL,
  `monto_muestreo` int(13) DEFAULT NULL,
  `monto_muestreo_oi` int(13) DEFAULT NULL,
  `monto_analisis` int(13) DEFAULT NULL,
  `flag_pagado` tinyint(1) DEFAULT NULL,
  `nro_n_credito` varchar(20) DEFAULT NULL,
  `monto_n_credito` int(13) DEFAULT NULL,
  `file_cotizacion` varchar(200) DEFAULT NULL,
  `transporte_envio1` int(5) DEFAULT NULL,
  `nro_envio1` varchar(50) DEFAULT NULL,
  `transporte_envio2` int(5) DEFAULT NULL,
  `nro_envio2` varchar(50) DEFAULT NULL,
  `persona_retira` varchar(100) DEFAULT NULL,
  `contacto_retira` varchar(200) DEFAULT NULL,
  `persona_recibe` varchar(100) DEFAULT NULL,
  `contacto_recibe` varchar(200) DEFAULT NULL,
  `fecha_recibe` date DEFAULT NULL,
  `id_us_destino0` int(5) DEFAULT NULL,
  `id_us_destino1` int(5) DEFAULT NULL,
  `id_us_destino2` int(5) DEFAULT NULL,
  `id_us_destino3` int(5) DEFAULT NULL,
  `id_us_destino4` int(5) DEFAULT NULL,
  `flag_infact` tinyint(1) DEFAULT NULL,
  `file_recepcion` varchar(500) DEFAULT NULL,
  `estado_caja` int(5) DEFAULT NULL,
  `medio_transporte` int(5) DEFAULT NULL,
  `comentarios` text,
  `cod_informe` int(5) DEFAULT NULL,
  `flag_prioritario` char(1) DEFAULT NULL,
  `abr` varchar(10) DEFAULT NULL,
  `flag_estado` tinyint(1) DEFAULT NULL,
  `flag_avisado` tinyint(1) DEFAULT NULL,
  `cod_rechazo` int(11) DEFAULT NULL,
  `file_acta` varchar(500) DEFAULT NULL,
  `last_update` timestamp NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `flag_aviso_fd` tinyint(1) DEFAULT NULL,
  `flag_composito_lab` tinyint(1) DEFAULT NULL,
  `fh_preparacion_c` datetime DEFAULT NULL,
  `preparador` varchar(200) DEFAULT NULL,
  `cantEnvases` int(5) DEFAULT NULL,
  `nro_carpeta_snp` varchar(100) DEFAULT NULL,
  `inspector_snp` varchar(100) DEFAULT NULL,
  `f_envio_mts` date DEFAULT NULL,
  `fecha_publicacion` datetime DEFAULT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_ingreso`),
  UNIQUE KEY `ind_id_ingreso` (`id_ingreso`) USING BTREE,
  KEY `ind_cli_ing` (`id_cliente`) USING BTREE,
  KEY `ind_ting_ing` (`id_tipo_ingreso`) USING BTREE,
  KEY `ind_fech_piblic` (`fecha_publicacion`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16384 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_locales
-- ----------------------------
DROP TABLE IF EXISTS `PDW_locales`;
CREATE TABLE `PDW_locales` (
  `WID_local` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WID_cliente` int(11) NOT NULL,
  `id_dependencia` int(11) NOT NULL,
  `id_cliente` int(11) NOT NULL,
  `nombre` varchar(100) DEFAULT NULL,
  `direccion` varchar(500) DEFAULT NULL,
  `gerencia` varchar(200) DEFAULT NULL,
  `flag_activo` tinyint(1) DEFAULT NULL,
  `version` int(6) DEFAULT NULL,
  `estado_dep` enum('Creado','Validado','Modificado','Baja','Eliminado') CHARACTER SET utf8 DEFAULT NULL,
  `id_usuario_upin` int(11) DEFAULT NULL,
  `id_usuario_vali` int(11) DEFAULT NULL,
  `fh_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_local`),
  UNIQUE KEY `ind_id_dependencia` (`id_dependencia`) USING BTREE,
  KEY `fk_local_clien` (`WID_cliente`) USING BTREE,
  CONSTRAINT `PDW_locales_ibfk_1` FOREIGN KEY (`WID_cliente`) REFERENCES `DW_clientes` (`WID_cliente`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4096 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_meses
-- ----------------------------
DROP TABLE IF EXISTS `PDW_meses`;
CREATE TABLE `PDW_meses` (
  `WID_mes` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(4) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `mes` int(11) NOT NULL,
  PRIMARY KEY (`WID_mes`),
  KEY `fk_anho_meses` (`WID_año`),
  KEY `fk_sem_mes` (`WID_semestre`),
  CONSTRAINT `fk_anho_meses` FOREIGN KEY (`WID_año`) REFERENCES `PDW_semestres` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_mes` FOREIGN KEY (`WID_semestre`) REFERENCES `PDW_semestres` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=613 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_metas_anuales
-- ----------------------------
DROP TABLE IF EXISTS `PDW_metas_anuales`;
CREATE TABLE `PDW_metas_anuales` (
  `WID_meta_anual` int(11) NOT NULL AUTO_INCREMENT,
  `WID_politica` int(11) NOT NULL,
  `WID_año` int(11) NOT NULL,
  `valor_anual` double(11,3) NOT NULL,
  `meta_anual` double(11,3) NOT NULL,
  PRIMARY KEY (`WID_meta_anual`),
  KEY `fk_meta_anu_año` (`WID_año`) USING BTREE,
  KEY `fk_obj_met_anu` (`WID_politica`) USING BTREE,
  CONSTRAINT `PDW_metas_anuales_ibfk_1` FOREIGN KEY (`WID_año`) REFERENCES `DW_años` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_metas_anuales_ibfk_2` FOREIGN KEY (`WID_politica`) REFERENCES `DW_politicas` (`WID_politica`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_metas_semestrales
-- ----------------------------
DROP TABLE IF EXISTS `PDW_metas_semestrales`;
CREATE TABLE `PDW_metas_semestrales` (
  `WID_meta_semestre` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WID_objetivo` int(11) NOT NULL,
  `WID_politica` int(11) NOT NULL,
  `WID_año` int(11) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `valor_semestral` double(11,3) NOT NULL,
  `meta_semestral` double(11,3) NOT NULL,
  PRIMARY KEY (`WID_meta_semestre`),
  KEY `fk_obj_metas` (`WID_politica`) USING BTREE,
  KEY `fk_metas_sem_semestre` (`WID_semestre`) USING BTREE,
  KEY `fk_metas_anho_semestre` (`WID_año`) USING BTREE,
  KEY `PDW_metas_semestrales_ibfk_4` (`WID_objetivo`),
  CONSTRAINT `PDW_metas_semestrales_ibfk_1` FOREIGN KEY (`WID_año`) REFERENCES `PDW_semestres` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_metas_semestrales_ibfk_2` FOREIGN KEY (`WID_semestre`) REFERENCES `PDW_semestres` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_metas_semestrales_ibfk_3` FOREIGN KEY (`WID_politica`) REFERENCES `PDW_politicas` (`WID_politica`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_metas_semestrales_ibfk_4` FOREIGN KEY (`WID_objetivo`) REFERENCES `PDW_politicas` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_muestras
-- ----------------------------
DROP TABLE IF EXISTS `PDW_muestras`;
CREATE TABLE `PDW_muestras` (
  `WID_muestra` int(11) NOT NULL AUTO_INCREMENT,
  `id_muestra` int(11) NOT NULL,
  `identificacion` int(11) NOT NULL,
  `duplicado` char(1) NOT NULL,
  `material_id` char(2) NOT NULL,
  `id_ingreso` int(11) NOT NULL,
  `id_tipo_muestra` int(11) NOT NULL,
  `clave` varchar(50) NOT NULL,
  `cod_submuestra` int(6) NOT NULL,
  `id_desc_prod` int(6) NOT NULL,
  `descripcion_muestra` varchar(500) NOT NULL,
  `cod_especie` int(6) NOT NULL,
  `t_ingreso` varchar(20) NOT NULL,
  `t_ingreso_error` varchar(5) NOT NULL,
  `t_corregida` varchar(5) NOT NULL,
  `id_termometro` int(6) NOT NULL,
  `vol_ingreso` varchar(7) NOT NULL,
  `ph_ingreso` decimal(5,0) NOT NULL,
  `flag_primario` char(1) NOT NULL,
  `flag_secundario` char(1) NOT NULL,
  `flag_refrigeracion` char(1) NOT NULL,
  `cant_refrigerante` int(3) NOT NULL,
  `flag_condicion` char(1) NOT NULL,
  `flag_identificacion` char(1) NOT NULL,
  `flag_testigo` char(1) NOT NULL,
  `flag_tmuestra` char(1) NOT NULL,
  `flag_nmuestras` char(1) NOT NULL,
  `flag_descripcion` char(1) NOT NULL,
  `flag_especie` char(1) NOT NULL,
  `flag_aceptado` char(1) NOT NULL,
  `estado_v` char(1) NOT NULL,
  `cod_val_resultados` int(6) NOT NULL,
  `n_muestras` int(3) NOT NULL,
  `obs_verificacion` varchar(5000) NOT NULL,
  `fh_verificacion` datetime NOT NULL,
  `idus_verificacion` int(11) NOT NULL,
  `foto` varchar(500) NOT NULL,
  `fecha_foto` varchar(500) NOT NULL,
  `hora_caudal` time NOT NULL,
  `caudal` varchar(20) NOT NULL,
  `formato_in` char(2) NOT NULL,
  `fecha_faena` varchar(50) NOT NULL,
  `fecha_elaboracion` varchar(100) NOT NULL,
  `fecha_vencimiento` varchar(50) NOT NULL,
  `temp_muestreo` varchar(10) NOT NULL,
  `frigorifico` varchar(200) NOT NULL,
  `cod_establecimiento` varchar(100) NOT NULL,
  `pais_origen` varchar(100) NOT NULL,
  `n_cortes` varchar(50) NOT NULL,
  `n_cajas` varchar(50) NOT NULL,
  `lote` varchar(100) NOT NULL,
  `datos_camion` varchar(100) NOT NULL,
  `flag_composito` char(1) NOT NULL,
  `contacto_manip` varchar(20) NOT NULL,
  `actividad_manip` varchar(200) NOT NULL,
  `seccion_manip` varchar(200) NOT NULL,
  `sala_manip` varchar(20) NOT NULL,
  `flag_cuadrante` char(1) NOT NULL,
  `cod_cuadrante` int(11) NOT NULL,
  `cod_regionh` int(6) NOT NULL,
  `cod_etapah` int(6) NOT NULL,
  `cod_consumoh` int(6) NOT NULL,
  `cod_tarroh` int(6) NOT NULL,
  `cod_peso_exph` int(6) NOT NULL,
  `cod_psmbh` int(6) NOT NULL,
  `cod_excepcionh` int(6) NOT NULL,
  `flag_acta` tinyint(1) NOT NULL,
  `last_update` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `flag_insert` varchar(255) DEFAULT '1',
  PRIMARY KEY (`WID_muestra`),
  KEY `ind_idIng_mue` (`id_ingreso`) USING BTREE,
  KEY `ind_idTm_mues` (`id_tipo_muestra`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=131071 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_objetivos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_objetivos`;
CREATE TABLE `PDW_objetivos` (
  `WID_objetivo` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(1000) NOT NULL,
  PRIMARY KEY (`WID_objetivo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_politicas
-- ----------------------------
DROP TABLE IF EXISTS `PDW_politicas`;
CREATE TABLE `PDW_politicas` (
  `WID_politica` int(11) NOT NULL AUTO_INCREMENT,
  `WID_objetivo` int(11) NOT NULL,
  `WID_proceso` int(11) NOT NULL,
  `WID_unidad` int(11) NOT NULL,
  `indicador` varchar(40) NOT NULL,
  `frecuencia` varchar(20) NOT NULL,
  PRIMARY KEY (`WID_politica`),
  KEY `fk_obj_politic_1` (`WID_objetivo`) USING BTREE,
  KEY `fk_unid_poli` (`WID_unidad`),
  KEY `fk_proc_poli` (`WID_proceso`),
  CONSTRAINT `fk_proc_poli` FOREIGN KEY (`WID_proceso`) REFERENCES `PDW_unidades` (`WID_proceso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_unid_poli` FOREIGN KEY (`WID_unidad`) REFERENCES `PDW_unidades` (`WID_unidad`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_politicas_ibfk_1` FOREIGN KEY (`WID_objetivo`) REFERENCES `PDW_unidades` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_preguntas
-- ----------------------------
DROP TABLE IF EXISTS `PDW_preguntas`;
CREATE TABLE `PDW_preguntas` (
  `WID_pregunta` int(11) NOT NULL AUTO_INCREMENT,
  `id_pregunta` int(11) NOT NULL,
  `cod_encuesta` varchar(10) NOT NULL,
  `pregunta` varchar(255) NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_pregunta`),
  UNIQUE KEY `ind_id_preg` (`id_pregunta`) USING BTREE,
  KEY `WID_pregunta` (`WID_pregunta`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for PDW_procesos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_procesos`;
CREATE TABLE `PDW_procesos` (
  `WID_proceso` int(11) NOT NULL AUTO_INCREMENT,
  `WID_objetivo` int(11) NOT NULL,
  `descripcion` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`WID_proceso`),
  KEY `fk_obj_proc` (`WID_objetivo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for PDW_reclamos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_reclamos`;
CREATE TABLE `PDW_reclamos` (
  `WID_reclamo` int(11) NOT NULL AUTO_INCREMENT,
  `WID_resumen_mensual_reclamo` int(11) NOT NULL,
  `id_reclamo` int(11) NOT NULL,
  `id_contacto_tecnico` int(11) NOT NULL,
  `ext_nombre` varchar(100) NOT NULL,
  `ext_mail` varchar(100) NOT NULL,
  `deteccion` enum('') NOT NULL,
  `area` varchar(500) NOT NULL,
  `descripcion` text NOT NULL,
  `id_ingreso_implicado` int(11) NOT NULL,
  `fh_abierto` datetime NOT NULL,
  `fh_cierre` date NOT NULL,
  `flag_aviso_cl` tinyint(1) NOT NULL,
  `flag_justificado` tinyint(1) NOT NULL,
  `justificacion` text NOT NULL,
  `flag_implicancias` tinyint(1) NOT NULL,
  `fecha_tnc` date NOT NULL,
  `just_implicancia` text NOT NULL,
  `flag_ea` tinyint(1) NOT NULL,
  `flag_oi` tinyint(1) NOT NULL,
  `fecha_aviso_oi` date NOT NULL,
  `id_ingreso_corregido` int(11) NOT NULL,
  `fecha_carta` date NOT NULL,
  `fecha_mail` date NOT NULL,
  `participantes` text NOT NULL,
  `estado` char(1) NOT NULL,
  `observaciones` text NOT NULL,
  `flag_eliminado` tinyint(1) DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_reclamo`),
  KEY `fk_res_rec_dw_rec` (`WID_resumen_mensual_reclamo`) USING BTREE,
  CONSTRAINT `PDW_reclamos_ibfk_1` FOREIGN KEY (`WID_resumen_mensual_reclamo`) REFERENCES `DW_resumen_mensual_reclamos` (`WID_resumen_mensual_reclamo`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_resumen_mensual_encuestas
-- ----------------------------
DROP TABLE IF EXISTS `PDW_resumen_mensual_encuestas`;
CREATE TABLE `PDW_resumen_mensual_encuestas` (
  `WID_resumen_mensual_encuesta` int(11) NOT NULL AUTO_INCREMENT,
  `WID_mes` int(11) NOT NULL,
  `WID_pregunta` int(11) NOT NULL,
  `suma_general` decimal(10,0) NOT NULL,
  `cant_clien_respond` int(11) NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_resumen_mensual_encuesta`),
  KEY `fk_resum_mes_enc` (`WID_mes`) USING BTREE,
  KEY `fk_preg_res_enc` (`WID_pregunta`),
  CONSTRAINT `fk_preg_res_enc` FOREIGN KEY (`WID_pregunta`) REFERENCES `PDW_preguntas` (`WID_pregunta`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_resumen_mensual_encuestas_ibfk_1` FOREIGN KEY (`WID_mes`) REFERENCES `DW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_resumen_mensual_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_resumen_mensual_ingresos`;
CREATE TABLE `PDW_resumen_mensual_ingresos` (
  `WID_resumen_mensual_ingreso` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(4) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `WID_tipo_ingreso` int(11) NOT NULL,
  `WID_tipo_muestra` int(11) NOT NULL,
  `WID_tipo_analisis` int(11) NOT NULL,
  `cant_ingresos` int(11) NOT NULL,
  `cant_muestras` int(11) NOT NULL,
  `cant_analisis` int(11) NOT NULL,
  `cant_informes` int(11) NOT NULL,
  `cant_infor_corr` int(11) NOT NULL,
  `cant_ingresos_mensual` int(11) NOT NULL,
  `cant_muestras_mensual` int(11) NOT NULL,
  `cant_analisis_mensual` int(11) NOT NULL,
  `cant_informes_mensual` int(11) NOT NULL,
  `cant_infor_corr_mensual` int(11) NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_resumen_mensual_ingreso`),
  KEY `fk_anho_resum_ing` (`WID_año`),
  KEY `fk_mes_resum_ing` (`WID_mes`),
  KEY `fk_semestre_resum_ing` (`WID_semestre`),
  KEY `fk_tAnali_resum_ing` (`WID_tipo_analisis`),
  KEY `fk_tIngre_resum_ing` (`WID_tipo_ingreso`),
  KEY `fk_tMues_resum_ing` (`WID_tipo_muestra`),
  CONSTRAINT `fk_anho_resum_ing` FOREIGN KEY (`WID_año`) REFERENCES `PDW_meses` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_mes_resum_ing` FOREIGN KEY (`WID_mes`) REFERENCES `PDW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_semestre_resum_ing` FOREIGN KEY (`WID_semestre`) REFERENCES `PDW_meses` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_tAnali_resum_ing` FOREIGN KEY (`WID_tipo_analisis`) REFERENCES `PDW_tipos_analisis` (`WID_tipo_analisis`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_tIngre_resum_ing` FOREIGN KEY (`WID_tipo_ingreso`) REFERENCES `PDW_tipos_ingresos` (`WID_tipo_ingreso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_tMues_resum_ing` FOREIGN KEY (`WID_tipo_muestra`) REFERENCES `PDW_tipos_muestras` (`WID_tipo_muestra`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8192 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_resumen_mensual_reclamos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_resumen_mensual_reclamos`;
CREATE TABLE `PDW_resumen_mensual_reclamos` (
  `WID_resumen_mensual_reclamo` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `WID_area` int(11) NOT NULL,
  `cant_reclamos` int(11) NOT NULL,
  `cant_reclamosOI` int(11) NOT NULL,
  `cant_trab_realiz` int(11) NOT NULL,
  `cant_reclamos_mensual` int(11) NOT NULL,
  `cant_reclamosOI_mensual` int(11) NOT NULL,
  `cant_trab_realiz_mensual` int(11) NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_resumen_mensual_reclamo`),
  KEY `fk_anho_res_rec` (`WID_año`) USING BTREE,
  KEY `fk_mes_res_rec` (`WID_mes`) USING BTREE,
  KEY `fk_area_res_rec` (`WID_area`) USING BTREE,
  CONSTRAINT `PDW_resumen_mensual_reclamos_ibfk_2` FOREIGN KEY (`WID_año`) REFERENCES `DW_meses` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_resumen_mensual_reclamos_ibfk_3` FOREIGN KEY (`WID_area`) REFERENCES `DW_area` (`WID_area`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `PDW_resumen_mensual_reclamos_ibfk_4` FOREIGN KEY (`WID_mes`) REFERENCES `DW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_semestres
-- ----------------------------
DROP TABLE IF EXISTS `PDW_semestres`;
CREATE TABLE `PDW_semestres` (
  `WID_semestre` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(11) NOT NULL,
  `semestre` int(11) NOT NULL,
  PRIMARY KEY (`WID_semestre`),
  KEY `fk_anho_semestre_1` (`WID_año`) USING BTREE,
  CONSTRAINT `fk_anho_sem` FOREIGN KEY (`WID_año`) REFERENCES `PDW_años` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_tipos_analisis
-- ----------------------------
DROP TABLE IF EXISTS `PDW_tipos_analisis`;
CREATE TABLE `PDW_tipos_analisis` (
  `WID_tipo_analisis` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_analisis` int(11) NOT NULL,
  `id_ta_padre` int(11) NOT NULL,
  `version` int(3) NOT NULL,
  `id_tipo_ingreso` int(11) NOT NULL,
  `id_tipo_muestra` int(11) NOT NULL,
  `id_envase` int(11) NOT NULL,
  `cod_area` int(6) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `cod_tecnica` int(6) NOT NULL,
  `cod_acreditacion` varchar(1000) NOT NULL,
  `norma` varchar(1000) NOT NULL,
  `tiempo_max` varchar(10) NOT NULL,
  `vol_muestra` varchar(50) NOT NULL,
  `cod_unidad` int(6) NOT NULL,
  `lim_deteccion` varchar(100) NOT NULL,
  `lim_cuantificacion` varchar(100) NOT NULL,
  `flag_vigente` tinyint(1) NOT NULL,
  `acred_muestreo` int(11) NOT NULL,
  `flag_cartacontrol` tinyint(1) NOT NULL,
  `id_usuario_upin` int(6) NOT NULL,
  `id_usuario_vali` int(6) NOT NULL,
  `flag_eliminado` tinyint(1) NOT NULL,
  `id_usuario_elim` int(6) NOT NULL,
  `id_usuario_conf` int(6) NOT NULL,
  `estado` char(1) NOT NULL,
  `update_timestamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_tipo_analisis`),
  UNIQUE KEY `ind_id_tipo_analisis` (`id_tipo_analisis`)
) ENGINE=InnoDB AUTO_INCREMENT=16384 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_tipos_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `PDW_tipos_ingresos`;
CREATE TABLE `PDW_tipos_ingresos` (
  `WID_tipo_ingreso` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_ingreso` int(11) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  `obs` varchar(100) NOT NULL,
  `last_update` datetime NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_tipo_ingreso`),
  UNIQUE KEY `ind_id_tipo_ingreso` (`id_tipo_ingreso`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_tipos_muestras
-- ----------------------------
DROP TABLE IF EXISTS `PDW_tipos_muestras`;
CREATE TABLE `PDW_tipos_muestras` (
  `WID_tipo_muestra` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_muestra` int(11) NOT NULL,
  `id_tipo_ingreso` int(11) NOT NULL,
  `item` varchar(50) NOT NULL,
  `ABR` char(3) NOT NULL,
  `descripcion` varchar(1000) NOT NULL,
  `matriz` int(6) NOT NULL,
  `des_primario` varchar(1000) NOT NULL,
  `des_secundario` varchar(1000) NOT NULL,
  `des_refrigeracion` varchar(1000) NOT NULL,
  `cant_refrigerante` varchar(50) NOT NULL,
  `des_condicion` varchar(1000) NOT NULL,
  `des_identificacion` varchar(1000) NOT NULL,
  `des_ttraslado` varchar(1000) NOT NULL,
  `des_temperatura` varchar(1000) NOT NULL,
  `des_testigo` varchar(1000) NOT NULL,
  `obs` varchar(100) NOT NULL,
  `flag_activo` tinyint(1) NOT NULL,
  `estado_materia` enum('') NOT NULL,
  `last_update` datetime NOT NULL,
  `flag_insert` varchar(2) DEFAULT '1',
  PRIMARY KEY (`WID_tipo_muestra`),
  UNIQUE KEY `index_id_tipo_muestra` (`id_tipo_muestra`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for PDW_unidades
-- ----------------------------
DROP TABLE IF EXISTS `PDW_unidades`;
CREATE TABLE `PDW_unidades` (
  `WID_unidad` int(11) NOT NULL,
  `WID_objetivo` int(11) NOT NULL,
  `WID_proceso` int(11) NOT NULL,
  `descripcion` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`WID_unidad`),
  KEY `fk_obj_unid` (`WID_objetivo`),
  KEY `fk_obj_proc` (`WID_proceso`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Procedure structure for insCompleteResIngresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insCompleteResIngresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insCompleteResIngresos`()
BEGIN
	SET foreign_key_checks = 0;
TRUNCATE TABLE PDW_resumen_mensual_ingresos;
INSERT INTO PDW_resumen_mensual_ingresos (
	WID_año,
	WID_semestre,
	WID_mes,
	WID_tipo_ingreso,
	WID_tipo_muestra,
	WID_tipo_analisis,
	cant_ingresos,
	cant_muestras,
	cant_analisis,
	cant_informes,
	cant_infor_corr
)
	SELECT
		fch.WID_anho AS año,
		fch.WID_semestre AS semestre,
		fch.WID_mes AS mes,
		ti.WID_tipo_ingreso AS tIngreso,
		tmu.WID_tipo_muestra AS tMuestra,
		tana.WID_tipo_analisis AS tAnalisis,
		count(DISTINCT ing.id_ingreso) AS c_ingreso,
		count(DISTINCT mu.id_muestra) AS c_muestra,
		count(DISTINCT ana.id_analisis) AS c_analisis,
		count(DISTINCT ing.id_ingreso) AS c_inform,
		COUNT(
			DISTINCT
			IF (
				ing.raya IS NOT NULL
				AND ing.raya LIKE '%-1%',
				CONCAT(
					ing.WID_ingreso,
					"/",
					ing.raya
				),
				NULL
			)
		) AS inf_corregidos
	FROM
		PDW_ingresos ing
	LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(ing.fecha_publicacion)
	LEFT JOIN PDW_tipos_ingresos ti ON ti.id_tipo_ingreso = ing.id_tipo_ingreso
	LEFT JOIN PDW_muestras mu ON mu.id_ingreso = ing.id_ingreso
	LEFT JOIN PDW_tipos_muestras tmu ON tmu.id_tipo_muestra = mu.id_tipo_muestra
	LEFT JOIN PDW_analisis ana ON ana.id_muestra = mu.id_muestra
	LEFT JOIN PDW_tipos_analisis tana ON tana.id_tipo_analisis = ana.id_tipo_analisis
	WHERE
		DATE(ing.fecha_publicacion) >= '2017-01-01'
	GROUP BY
		fch.WID_anho,
		fch.WID_semestre,
		fch.WID_mes,
		ing.id_tipo_ingreso,
		tmu.id_tipo_muestra,
		ana.id_tipo_analisis;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insCompleteResReclamos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insCompleteResReclamos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insCompleteResReclamos`()
BEGIN

SET foreign_key_checks = 0;

TRUNCATE TABLE PDW_resumen_mensual_reclamos;

INSERT INTO PDW_resumen_mensual_reclamos (
	WID_año,
	WID_mes,
	WID_area,
	cant_reclamos,
	cant_reclamosOI,
	cant_trab_realiz,
	cant_reclamos_mensual,
	cant_reclamosOI_mensual,
	cant_trab_realiz_mensual
) SELECT
	fch.WID_anho AS año,
	fch.WID_mes AS mes,
	ar.WID_area AS area,
	SUM(IF(rec.flag_ea = 1, 1, 0)) AS cant_reclamos,
	SUM(IF(rec.flag_oi = 1, 1, 0)) AS cant_recl_snp,

IF (
	ar.WID_area IN (5, 6, 7),
	(
		SELECT
			count(WID_ingreso)
		FROM
			PDW_ingresos
		WHERE
			DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
		AND raya IS NULL
		AND id_cliente != 831
		AND id_tipo_ingreso = (
			CASE
			WHEN ar.WID_area = 5 THEN
				1
			WHEN ar.WID_area = 6 THEN
				2
			WHEN ar.WID_area = 7 THEN
				3
			ELSE
				ar.WID_area
			END
		)
	),
	(
		SELECT
			count(WID_ingreso)
		FROM
			PDW_ingresos
		WHERE
			DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
		AND raya IS NULL
		AND id_cliente != 831
	)
) AS cant_trab_realiz,
 (
	SELECT
		count(WID_reclamo)
	FROM
		PDW_reclamos
	WHERE
		DATE_FORMAT(fh_cierre, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
	AND flag_ea = 1
) AS cant_recl_mensual,
 (
	SELECT
		count(WID_reclamo)
	FROM
		PDW_reclamos
	WHERE
		DATE_FORMAT(fh_cierre, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
	AND flag_oi = 1
) AS cant_recl_snp_mensual,
 (
	SELECT
		count(*)
	FROM
		PDW_ingresos
	WHERE
		DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
	AND raya IS NULL
	AND id_cliente != 831
) AS cant_trabaj_realiz_mensual
FROM
	PDW_reclamos rec
LEFT JOIN PDW_fechas fch ON fch.fecha = rec.fh_cierre
LEFT JOIN PDW_area ar ON ar.area = rec.area
WHERE
	rec.fh_cierre >= '2017-01-01'
GROUP BY
	fch.WID_anho,
	fch.WID_mes,
	date_format(fch.fecha, '%Y-%m'),
	ar.WID_area;


SET foreign_key_checks = 1;


END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimAnhos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimAnhos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimAnhos`()
BEGIN
SET foreign_key_checks = 0;
truncate table PDW_años;
SET foreign_key_checks = 1;
INSERT INTO PDW_años(año) values (1990),(1991),(1992),(1993),(1994),(1995),(1996),(1997),(1998),(1999),(2000),(2001),(2002),(2003),(2004),(2005),(2006),(2007),(2008),(2009),(2010),(2011),(2012),(2013),(2014),(2015),(2016),(2017),(2018),(2019),(2020),(2021),(2022),(2023),(2024),(2025),(2026),(2027),(2028),(2029),(2030),(2031),(2032),(2033),(2034),(2035),(2036),(2037),(2038),(2039),(2040);
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimAreas
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimAreas`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimAreas`()
BEGIN
INSERT INTO PDW_area(id_area,area,last_update) 
SELECT cg.id_codigo_g,cg.descripcion ,cg.last_update
FROM biripit_stage_dw_silob.codigos_g cg 
ON DUPLICATE KEY UPDATE
id_area = cg.id_codigo_g,
area = cg.descripcion,
last_update = cg.last_update,
flag_insert = '2';
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimCliente
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimCliente`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimCliente`()
BEGIN
	INSERT INTO PDW_clientes(id_cliente,razon_social,nombre,nro_rut,dv_rut,direccion,cont_facturacion,fono_cont,
fono2_cont,mail_cont,cod_ciiu,cod_status,pub_local,pub_descrip,pub_fecham,estado_cl,version,flag_vigente,id_usuario_upin,
id_usuario_vali,update_timestamp,flag_eliminado) 
SELECT cl.id_cliente,cl.razon_social,cl.nombre,cl.nro_rut,cl.dv_rut,cl.direccion,cl.cont_facturacion,cl.fono_cont,
cl.fono2_cont,cl.mail_cont,cl.cod_ciiu,cl.cod_status,cl.pub_local,cl.pub_descrip,cl.pub_fecham,cl.estado_cl,
cl.version,cl.flag_vigente,cl.id_usuario_upin,cl.id_usuario_vali,cl.update_timestamp,cl.flag_eliminado
FROM biripit_stage_dw_silob.clientes cl
ON DUPLICATE KEY UPDATE 
id_cliente=cl.id_cliente,
razon_social=cl.razon_social,
nombre=cl.nombre,
nro_rut=cl.nro_rut,
dv_rut=cl.dv_rut,
direccion=cl.direccion,
cont_facturacion=cl.cont_facturacion,
fono_cont=cl.fono_cont,
fono2_cont=cl.fono2_cont,
mail_cont=cl.mail_cont,
cod_ciiu=cl.cod_ciiu,
cod_status=cl.cod_status,
pub_local=cl.pub_local,
pub_descrip=cl.pub_descrip,
pub_fecham=cl.pub_fecham,
estado_cl=cl.estado_cl,
version=cl.version,
flag_vigente=cl.flag_vigente,
id_usuario_upin=cl.id_usuario_upin,
id_usuario_vali=cl.id_usuario_vali,
update_timestamp=cl.update_timestamp,
flag_eliminado=cl.flag_eliminado,
flag_insert='2';
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimLocales
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimLocales`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimLocales`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO biripit_pre_dw_silob.PDW_locales (WID_cliente,id_dependencia,id_cliente,nombre,direccion,gerencia,flag_activo,
version,estado_dep,id_usuario_upin,id_usuario_vali,fh_update)
SELECT 
cl.WID_cliente,dep.id_dependencia,dep.id_cliente,dep.nombre,dep.direccion,dep.gerencia,dep.flag_activo,
dep.version,dep.estado_dep,dep.id_usuario_upin,dep.id_usuario_vali,dep.fh_update
FROM biripit_stage_dw_silob.dependencias dep
LEFT JOIN biripit_pre_dw_silob.PDW_clientes cl ON dep.id_cliente = cl.id_cliente 
ON DUPLICATE KEY UPDATE
id_dependencia = dep.id_dependencia,
id_cliente = dep.id_cliente,
nombre = dep.nombre,
direccion = dep.direccion,
gerencia = dep.gerencia,
flag_activo = dep.flag_activo,
version = dep.version,
estado_dep = dep.estado_dep,
id_usuario_upin = dep.id_usuario_upin,
id_usuario_vali = dep.id_usuario_vali,
fh_update = dep.fh_update,
flag_insert = '2';
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimTiposAnalisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimTiposAnalisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimTiposAnalisis`()
BEGIN
	INSERT INTO PDW_tipos_analisis(id_tipo_analisis,id_ta_padre,version,id_tipo_ingreso,id_tipo_muestra,id_envase,
cod_area,nombre,name,cod_tecnica,cod_acreditacion,norma,tiempo_max,vol_muestra,cod_unidad,lim_deteccion,lim_cuantificacion,
flag_vigente,acred_muestreo,flag_cartacontrol,id_usuario_upin,id_usuario_vali,flag_eliminado,id_usuario_elim,id_usuario_conf,
estado,update_timestamp) SELECT 
ta.id_tipo_analisis,ta.id_ta_padre,ta.version,ta.id_tipo_ingreso,ta.id_tipo_muestra,
ta.id_envase,ta.cod_area,ta.nombre,ta.name,ta.cod_tecnica,ta.cod_acreditacion,ta.norma,ta.tiempo_max,ta.vol_muestra,
ta.cod_unidad,ta.lim_deteccion,ta.lim_cuantificacion,ta.flag_vigente,ta.acred_muestreo,ta.flag_cartacontrol,
ta.id_usuario_upin,ta.id_usuario_vali,ta.flag_eliminado,ta.id_usuario_elim,ta.id_usuario_conf,ta.estado,ta.update_timestamp
FROM biripit_stage_dw_silob.tipos_analisis ta ON DUPLICATE KEY UPDATE
id_tipo_analisis=ta.id_tipo_analisis ,
id_ta_padre=ta.id_ta_padre,
version=ta.version,
id_tipo_ingreso=ta.id_tipo_ingreso,
id_tipo_muestra=ta.id_tipo_muestra,
id_envase=ta.id_envase,
cod_area=ta.cod_area,
nombre=ta.nombre,
name=ta.name,
cod_tecnica=ta.cod_tecnica,
cod_acreditacion=ta.cod_acreditacion,
norma=ta.norma,
tiempo_max=ta.tiempo_max,
vol_muestra=ta.vol_muestra,
cod_unidad=ta.cod_unidad,
lim_deteccion=ta.lim_deteccion,
lim_cuantificacion=ta.lim_cuantificacion,
flag_vigente=ta.flag_vigente,
acred_muestreo=ta.acred_muestreo,
flag_cartacontrol=ta.flag_cartacontrol,
id_usuario_upin=ta.id_usuario_upin,
id_usuario_vali=ta.id_usuario_vali,
flag_eliminado=ta.flag_eliminado,
id_usuario_elim=ta.id_usuario_elim,
id_usuario_conf=ta.id_usuario_conf,
estado=ta.estado,
update_timestamp=ta.update_timestamp,
flag_insert = '2';
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimTiposIngresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimTiposIngresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimTiposIngresos`()
BEGIN
	INSERT INTO PDW_tipos_ingresos(id_tipo_ingreso,descripcion,obs,last_update) 
	SELECT tp.id_tipo_ingreso,tp.descripcion,tp.obs,tp.last_update FROM biripit_stage_dw_silob.tipos_ingresos tp 
	ON DUPLICATE KEY UPDATE
	id_tipo_ingreso=tp.id_tipo_ingreso,
	descripcion=tp.descripcion,
	obs=tp.obs,
	last_update=tp.last_update,
	flag_insert ='2';
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimTiposMuestras
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimTiposMuestras`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimTiposMuestras`()
BEGIN
INSERT INTO PDW_tipos_muestras (id_tipo_muestra,id_tipo_ingreso,item,ABR,descripcion,matriz,des_primario,
des_secundario,des_refrigeracion,cant_refrigerante,des_condicion,des_identificacion,des_ttraslado,des_temperatura,
des_testigo,obs,flag_activo,estado_materia,last_update)
SELECT 
tm.id_tipo_muestra,tm.id_tipo_ingreso,tm.item,tm.ABR,tm.descripcion,tm.matriz,tm.des_primario,tm.des_secundario,
tm.des_refrigeracion,tm.cant_refrigerante,tm.des_condicion,tm.des_identificacion,tm.des_ttraslado,tm.des_temperatura,
tm.des_testigo,tm.obs,tm.flag_activo,tm.estado_materia,tm.last_update
FROM biripit_stage_dw_silob.tipos_muestras tm ON DUPLICATE KEY UPDATE
id_tipo_muestra = tm.id_tipo_muestra,
id_tipo_ingreso = tm.id_tipo_ingreso,
item = tm.item,
ABR = tm.ABR,
descripcion = tm.descripcion,
matriz = tm.matriz,
des_primario = tm.des_primario,
des_secundario = tm.des_secundario,
des_refrigeracion = tm.des_refrigeracion,
cant_refrigerante = tm.cant_refrigerante,
des_condicion = tm.des_condicion,
des_identificacion = tm.des_identificacion,
des_ttraslado = tm.des_ttraslado,
des_temperatura = tm.des_temperatura,
des_testigo = tm.des_testigo,
obs = tm.obs,
flag_activo = tm.flag_activo,
estado_materia = tm.estado_materia,
last_update = tm.last_update,
flag_insert = '2';
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteAnalisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteAnalisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteAnalisis`()
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_analisis;
INSERT INTO biripit_pre_dw_silob.PDW_analisis (id_analisis,id_tipo_analisis,variacion,id_muestra,cod_norma_val,
cod_unidad,cod_acreditacion,id_envase,id_set,id_cartacontrol,last_update)
SELECT
	ana.id_analisis,ana.id_tipo_analisis,ana.variacion,ana.id_muestra,ana.cod_norma_val,
ana.cod_unidad,ana.cod_acreditacion,ana.id_envase,ana.id_set,ana.id_cartacontrol,ana.last_update
FROM
	biripit_stage_dw_silob.analisis ana;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteAreas
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteAreas`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteAreas`()
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_area;
INSERT INTO biripit_pre_dw_silob.PDW_area (id_area,area,last_update)
SELECT 
cg.id_codigo_g,cg.descripcion ,cg.last_update
FROM biripit_stage_dw_silob.codigos_g cg WHERE cg.cod_tabla='SIS_AREACC';
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteClientes
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteClientes`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteClientes`()
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_clientes;
INSERT INTO biripit_pre_dw_silob.PDW_clientes (id_cliente,razon_social,nombre,nro_rut,dv_rut,direccion,cont_facturacion,fono_cont,
fono2_cont,mail_cont,cod_ciiu,cod_status,pub_local,pub_descrip,pub_fecham,estado_cl,version,flag_vigente,id_usuario_upin,
id_usuario_vali,update_timestamp,flag_eliminado)
SELECT 
cl.id_cliente,cl.razon_social,cl.nombre,cl.nro_rut,cl.dv_rut,cl.direccion,cl.cont_facturacion,cl.fono_cont,
cl.fono2_cont,cl.mail_cont,cl.cod_ciiu,cl.cod_status,cl.pub_local,cl.pub_descrip,cl.pub_fecham,cl.estado_cl,
cl.version,cl.flag_vigente,cl.id_usuario_upin,cl.id_usuario_vali,cl.update_timestamp,cl.flag_eliminado
FROM biripit_stage_dw_silob.clientes cl;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteDependencias
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteDependencias`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteDependencias`()
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_locales;
INSERT INTO biripit_pre_dw_silob.PDW_locales (WID_cliente,id_dependencia,id_cliente,nombre,direccion,gerencia,flag_activo,
version,estado_dep,id_usuario_upin,id_usuario_vali,fh_update)
SELECT 
cl.WID_cliente,dep.id_dependencia,dep.id_cliente,dep.nombre,dep.direccion,dep.gerencia,dep.flag_activo,
dep.version,dep.estado_dep,dep.id_usuario_upin,dep.id_usuario_vali,dep.fh_update
FROM biripit_pre_dw_silob.PDW_clientes cl
LEFT JOIN biripit_stage_dw_silob.dependencias dep ON dep.id_cliente=cl.id_cliente
WHERE dep.id_dependencia!=0 AND dep.id_dependencia IS NOT NULL;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteIngresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteIngresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteIngresos`()
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_ingresos;
INSERT INTO biripit_pre_dw_silob.PDW_ingresos(id_ingreso,id_tipo_ingreso,id_cliente,id_dependencia,id_usuario_ingreso,id_usuario_validacion,id_factura,nro_ingreso,
raya,flag_reemplazado,flag_foto_informe,flag_carta,flag_sma,titular_proyecto,rut_titular,representante,rut_representante,proyecto,instrumentos,muestreador,
nro_requerimiento,fh_validacion,fecha_ingreso,hora_ingreso,certificacion_snp,nro_formulario_snp,cod_destino_snp,cod_categoria,lugar_descarga,f_i_muestreo,
f_muestreo,fh_almacenamiento,h_i_muestreo,h_t_muestreo,f_i_verificacion,f_t_verificacion,cont_muestreo,nro_muestreo,id_muestreador,nro_muestreo2,id_muestreador2,
cod_entrega,entidad_m,flag_limites,lugar_muestreo,envases_cliente,coleman_cliente,otros_bienes_cliente,fh_informe,flag_caudal,flag_compuesta,fh_v_destino0,
fh_s_destino0,cod_destino1,fh_i_destino1,fh_s_destino1,cod_destino2,fh_i_destino2,fh_s_destino2,cod_destino3,fh_i_destino3,fh_s_destino3,cod_destino4,
fh_i_destino4,fh_s_destino4,cod_destino5,nro_fact,fh_fact,monto_muestreo,monto_muestreo_oi,monto_analisis,flag_pagado,nro_n_credito,monto_n_credito,
file_cotizacion,transporte_envio1,nro_envio1,transporte_envio2,nro_envio2,persona_retira,contacto_retira,persona_recibe,contacto_recibe,fecha_recibe,
id_us_destino0,id_us_destino1,id_us_destino2,id_us_destino3,id_us_destino4,flag_infact,file_recepcion,estado_caja,medio_transporte,comentarios,cod_informe,
flag_prioritario,abr,flag_estado,flag_avisado,cod_rechazo,file_acta,last_update,flag_aviso_fd,flag_composito_lab,fh_preparacion_c,preparador,cantEnvases,
nro_carpeta_snp,inspector_snp,f_envio_mts,fecha_publicacion)
SELECT
	ing.id_ingreso,
	ing.id_tipo_ingreso,
	ing.id_cliente,
	ing.id_dependencia,
	ing.id_usuario_ingreso,
	ing.id_usuario_validacion,
	ing.id_factura,
	ing.nro_ingreso,
	ing.raya,
	ing.flag_reemplazado,
	ing.flag_foto_informe,
	ing.flag_carta,
	ing.flag_sma,
	ing.titular_proyecto,
	ing.rut_titular,
	ing.representante,
	ing.rut_representante,
	ing.proyecto,
	ing.instrumentos,
	ing.muestreador,
	ing.nro_requerimiento,
	ing.fh_validacion,
	ing.fecha_ingreso,
	ing.hora_ingreso,
	ing.certificacion_snp,
	ing.nro_formulario_snp,
	ing.cod_destino_snp,
	ing.cod_categoria,
	ing.lugar_descarga,
	ing.f_i_muestreo,
	ing.f_muestreo,
	ing.fh_almacenamiento,
	ing.h_i_muestreo,
	ing.h_t_muestreo,
	ing.f_i_verificacion,
	ing.f_t_verificacion,
	ing.cont_muestreo,
	ing.nro_muestreo,
	ing.id_muestreador,
	ing.nro_muestreo2,
	ing.id_muestreador2,
	ing.cod_entrega,
	ing.entidad_m,
	ing.flag_limites,
	ing.lugar_muestreo,
	ing.envases_cliente,
	ing.coleman_cliente,
	ing.otros_bienes_cliente,
	ing.fh_informe,
	ing.flag_caudal,
	ing.flag_compuesta,
	ing.fh_v_destino0,
	ing.fh_s_destino0,
	ing.cod_destino1,
	ing.fh_i_destino1,
	ing.fh_s_destino1,
	ing.cod_destino2,
	ing.fh_i_destino2,
	ing.fh_s_destino2,
	ing.cod_destino3,
	ing.fh_i_destino3,
	ing.fh_s_destino3,
	ing.cod_destino4,
	ing.fh_i_destino4,
	ing.fh_s_destino4,
	ing.cod_destino5,
	ing.nro_fact,
	ing.fh_fact,
	ing.monto_muestreo,
	ing.monto_muestreo_oi,
	ing.monto_analisis,
	ing.flag_pagado,
	ing.nro_n_credito,
	ing.monto_n_credito,
	ing.file_cotizacion,
	ing.transporte_envio1,
	ing.nro_envio1,
	ing.transporte_envio2,
	ing.nro_envio2,
	ing.persona_retira,
	ing.contacto_retira,
	ing.persona_recibe,
	ing.contacto_recibe,
	ing.fecha_recibe,
	ing.id_us_destino0,
	ing.id_us_destino1,
	ing.id_us_destino2,
	ing.id_us_destino3,
	ing.id_us_destino4,
	ing.flag_infact,
	ing.file_recepcion,
	ing.estado_caja,
	ing.medio_transporte,
	ing.comentarios,
	ing.cod_informe,
	ing.flag_prioritario,
	ing.abr,
	ing.flag_estado,
	ing.flag_avisado,
	ing.cod_rechazo,
	ing.file_acta,
	ing.last_update,
	ing.flag_aviso_fd,
	ing.flag_composito_lab,
	ing.fh_preparacion_c,
	ing.preparador,
	ing.cantEnvases,
	ing.nro_carpeta_snp,
	ing.inspector_snp,
	ing.f_envio_mts,
	ing.fecha_publicacion
FROM
	biripit_stage_dw_silob.ingresos ing;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteMuestras
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteMuestras`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteMuestras`()
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_muestras;
INSERT INTO biripit_pre_dw_silob.PDW_muestras(id_muestra,identificacion,duplicado,material_id,id_ingreso,id_tipo_muestra,
clave,cod_submuestra,id_desc_prod,descripcion_muestra,cod_especie,t_ingreso,t_ingreso_error,t_corregida,id_termometro,
vol_ingreso,ph_ingreso,flag_primario,flag_secundario,flag_refrigeracion,cant_refrigerante,flag_condicion,flag_identificacion,
flag_testigo,flag_tmuestra,flag_nmuestras,flag_descripcion,flag_especie,flag_aceptado,estado_v,cod_val_resultados,n_muestras,
obs_verificacion,fh_verificacion,idus_verificacion,foto,fecha_foto,hora_caudal,caudal,formato_in,fecha_faena,fecha_elaboracion,
fecha_vencimiento,temp_muestreo,frigorifico,cod_establecimiento,pais_origen,n_cortes,n_cajas,lote,datos_camion,flag_composito,
contacto_manip,actividad_manip,seccion_manip,sala_manip,flag_cuadrante,cod_cuadrante,cod_regionh,cod_etapah,cod_consumoh,
cod_tarroh,cod_peso_exph,cod_psmbh,cod_excepcionh,flag_acta,last_update)
SELECT 
	mue.id_muestra,
	mue.identificacion,
	mue.duplicado,
	mue.material_id,
	mue.id_ingreso,
	mue.id_tipo_muestra,
	mue.clave,
	mue.cod_submuestra,
	mue.id_desc_prod,
	mue.descripcion_muestra,
	mue.cod_especie,
	mue.t_ingreso,
	mue.t_ingreso_error,
	mue.t_corregida,
	mue.id_termometro,
	mue.vol_ingreso,
	mue.ph_ingreso,
	mue.flag_primario,
	mue.flag_secundario,
	mue.flag_refrigeracion,
	mue.cant_refrigerante,
	mue.flag_condicion,
	mue.flag_identificacion,
	mue.flag_testigo,
	mue.flag_tmuestra,
	mue.flag_nmuestras,
	mue.flag_descripcion,
	mue.flag_especie,
	mue.flag_aceptado,
	mue.estado_v,
	mue.cod_val_resultados,
	mue.n_muestras,
	mue.obs_verificacion,
	mue.fh_verificacion,
	mue.idus_verificacion,
	mue.foto,
	mue.fecha_foto,
	mue.hora_caudal,
	mue.caudal,
	mue.formato_in,
	mue.fecha_faena,
	mue.fecha_elaboracion,
	mue.fecha_vencimiento,
	mue.temp_muestreo,
	mue.frigorifico,
	mue.cod_establecimiento,
	mue.pais_origen,
	mue.n_cortes,
	mue.n_cajas,
	mue.lote,
	mue.datos_camion,
	mue.flag_composito,
	mue.contacto_manip,
	mue.actividad_manip,
	mue.seccion_manip,
	mue.sala_manip,
	mue.flag_cuadrante,
	mue.cod_cuadrante,
	mue.cod_regionh,
	mue.cod_etapah,
	mue.cod_consumoh,
	mue.cod_tarroh,
	mue.cod_peso_exph,
	mue.cod_psmbh,
	mue.cod_excepcionh,
	mue.flag_acta,
	mue.last_update
FROM
	biripit_stage_dw_silob.muestras mue;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insertCompleteReclamos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insertCompleteReclamos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insertCompleteReclamos`()
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_reclamos;
INSERT INTO biripit_pre_dw_silob.PDW_reclamos (id_reclamo,id_contacto_tecnico,ext_nombre,ext_mail,deteccion,area,descripcion,
id_ingreso_implicado,fh_abierto,fh_cierre,flag_aviso_cl,flag_justificado,justificacion,flag_implicancias,fecha_tnc,
just_implicancia,flag_ea,flag_oi,fecha_aviso_oi,id_ingreso_corregido,fecha_carta,fecha_mail,participantes,estado,observaciones,
flag_eliminado)
SELECT 
rec.id_reclamo,rec.id_contacto_tecnico,rec.ext_nombre,rec.ext_mail,rec.deteccion,rec.area,rec.descripcion,
rec.id_ingreso_implicado,rec.fh_abierto,rec.fh_cierre,rec.flag_aviso_cl,rec.flag_justificado,rec.justificacion,
rec.flag_implicancias,rec.fecha_tnc,rec.just_implicancia,rec.flag_ea,rec.flag_oi,rec.fecha_aviso_oi,rec.id_ingreso_corregido,
rec.fecha_carta,rec.fecha_mail,rec.participantes,rec.estado,rec.observaciones,rec.flag_eliminado
FROM biripit_stage_dw_silob.reclamos rec;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteTiposAnalisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteTiposAnalisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteTiposAnalisis`()
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_tipos_analisis;
INSERT INTO biripit_pre_dw_silob.PDW_tipos_analisis (id_tipo_analisis,id_ta_padre,version,id_tipo_ingreso,id_tipo_muestra,
id_envase,cod_area,nombre,name,cod_tecnica,cod_acreditacion,norma,tiempo_max,vol_muestra,cod_unidad,lim_deteccion,
lim_cuantificacion,flag_vigente,acred_muestreo,flag_cartacontrol,id_usuario_upin,id_usuario_vali,flag_eliminado,
id_usuario_elim,id_usuario_conf,estado,update_timestamp)
SELECT 
ta.id_tipo_analisis,ta.id_ta_padre,ta.version,ta.id_tipo_ingreso,ta.id_tipo_muestra,
ta.id_envase,ta.cod_area,ta.nombre,ta.name,ta.cod_tecnica,ta.cod_acreditacion,ta.norma,ta.tiempo_max,ta.vol_muestra,
ta.cod_unidad,ta.lim_deteccion,ta.lim_cuantificacion,ta.flag_vigente,ta.acred_muestreo,ta.flag_cartacontrol,
ta.id_usuario_upin,ta.id_usuario_vali,ta.flag_eliminado,ta.id_usuario_elim,ta.id_usuario_conf,ta.estado,ta.update_timestamp
FROM biripit_stage_dw_silob.tipos_analisis ta;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteTiposIngresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteTiposIngresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteTiposIngresos`()
BEGIN
  SET foreign_key_checks = 0;
	truncate table PDW_tipos_ingresos;
	INSERT INTO PDW_tipos_ingresos(id_tipo_ingreso,descripcion,obs,last_update) 
	SELECT tp.id_tipo_ingreso,tp.descripcion,tp.obs,tp.last_update 
FROM biripit_stage_dw_silob.tipos_ingresos tp;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for InsertCompleteTiposMuestras
-- ----------------------------
DROP PROCEDURE IF EXISTS `InsertCompleteTiposMuestras`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `InsertCompleteTiposMuestras`()
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_pre_dw_silob.PDW_tipos_muestras;
INSERT INTO biripit_pre_dw_silob.PDW_tipos_muestras (id_tipo_muestra,id_tipo_ingreso,item,ABR,descripcion,matriz,des_primario,
des_secundario,des_refrigeracion,cant_refrigerante,des_condicion,des_identificacion,des_ttraslado,des_temperatura,
des_testigo,obs,flag_activo,estado_materia,last_update)
SELECT 
tm.id_tipo_muestra,tm.id_tipo_ingreso,tm.item,tm.ABR,tm.descripcion,tm.matriz,tm.des_primario,tm.des_secundario,
tm.des_refrigeracion,tm.cant_refrigerante,tm.des_condicion,tm.des_identificacion,tm.des_ttraslado,tm.des_temperatura,
tm.des_testigo,tm.obs,tm.flag_activo,tm.estado_materia,tm.last_update
FROM biripit_stage_dw_silob.tipos_muestras tm;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insResCompleteEncuestas
-- ----------------------------
DROP PROCEDURE IF EXISTS `insResCompleteEncuestas`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insResCompleteEncuestas`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO 
	PDW_resumen_mensual_encuestas (
		WID_mes,
		WID_pregunta,
		suma_general,
		cant_clien_respond
	)
SELECT
	fch.WID_mes,
	preg.WID_pregunta,
	count(DISTINCT encu.id_contacto) as total_respondieron,
	sum(encu.valor_pregunta) as valor_total
FROM
	PDW_encuestas encu
LEFT JOIN PDW_preguntas preg ON preg.id_pregunta = encu.id_pregunta
LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(encu.fecha)
WHERE
 encu.valor_pregunta IS NOT NULL AND DATE(encu.fecha) >= '2017-01-01'
GROUP BY DATE_FORMAT(encu.fecha, "%Y-%m"),encu.id_pregunta;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insResEncuestas
-- ----------------------------
DROP PROCEDURE IF EXISTS `insResEncuestas`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insResEncuestas`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO 
	PDW_resumen_mensual_encuestas (
		WID_mes,
		WID_pregunta,
		suma_general,
		cant_clien_respond
	)
SELECT
	fch.WID_mes,
	preg.WID_pregunta,
	sum(encu.valor_pregunta) as valor_total,
	count(encu.id_encuesta) as total_respondieron
FROM
	PDW_encuestas encu
LEFT JOIN PDW_preguntas preg ON preg.id_pregunta = encu.id_pregunta
LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(encu.fecha)
WHERE
 encu.valor_pregunta IS NOT NULL
GROUP BY DATE_FORMAT(encu.fecha, "%Y-%m"),encu.id_pregunta;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insResReclamos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insResReclamos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insResReclamos`(IN `fecha` DATE)
BEGIN
SET foreign_key_checks = 0;
INSERT INTO PDW_resumen_mensual_reclamos(
WID_año,
WID_mes,
WID_area,
cant_reclamos,
cant_reclamosOI,
cant_trab_realiz,
cant_reclamos_mensual,
cant_reclamosOI_mensual,
cant_trab_realiz_mensual
)
SELECT
	fch.WID_anho AS año,
	fch.WID_mes AS mes,
	ar.WID_area AS area,
	SUM(IF(rec.flag_ea = 1, 1, 0)) AS cant_reclamos,
	SUM(IF(rec.flag_oi = 1, 1, 0)) AS cant_recl_snp,

IF (
	ar.WID_area IN (5, 6, 7),
	(
		SELECT
			count(WID_ingreso)
		FROM
			PDW_ingresos
		WHERE
			DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
		AND raya IS NULL
		AND id_cliente != 831
		AND id_tipo_ingreso = (
			CASE
			WHEN ar.WID_area = 5 THEN
				1
			WHEN ar.WID_area = 6 THEN
				2
			WHEN ar.WID_area = 7 THEN
				3
			ELSE
				ar.WID_area
			END
		)
	),
	(
		SELECT
			count(WID_ingreso)
		FROM
			PDW_ingresos
		WHERE
			DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
		AND raya IS NULL
		AND id_cliente != 831
	)
) AS cant_trab_realiz,
 (
	SELECT
		count(WID_reclamo)
	FROM
		PDW_reclamos
	WHERE
		DATE_FORMAT(fh_cierre, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
	AND flag_ea = 1
) AS cant_recl_mensual,
 (
	SELECT
		count(WID_reclamo)
	FROM
		PDW_reclamos
	WHERE
		DATE_FORMAT(fh_cierre, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
	AND flag_oi = 1
) AS cant_recl_snp_mensual,
 (
	SELECT
		count(*)
	FROM
		PDW_ingresos
	WHERE
		DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
	AND raya IS NULL
	AND id_cliente != 831
) AS cant_trabaj_realiz_mensual
FROM
	PDW_reclamos rec
LEFT JOIN PDW_fechas fch ON fch.fecha = rec.fh_cierre
LEFT JOIN PDW_area ar ON ar.area = rec.area
WHERE
	rec.fh_cierre >= '2017-01-01'
GROUP BY
	fch.WID_anho,
	fch.WID_mes,
	date_format(fch.fecha, '%Y-%m'),
	ar.WID_area;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransAnalisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransAnalisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransAnalisis`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO biripit_pre_dw_silob.PDW_analisis (id_analisis,id_tipo_analisis,variacion,id_muestra,cod_norma_val,
cod_unidad,cod_acreditacion,id_envase,id_set,id_cartacontrol,last_update)
SELECT 
ana.id_analisis,ana.id_tipo_analisis,ana.variacion,ana.id_muestra,ana.cod_norma_val,
ana.cod_unidad,ana.cod_acreditacion,ana.id_envase,ana.id_set,ana.id_cartacontrol,ana.last_update
FROM biripit_stage_dw_silob.analisis ana 
ON DUPLICATE KEY UPDATE 
id_analisis = ana.id_analisis,
id_tipo_analisis = ana.id_tipo_analisis,
variacion = ana.variacion,
id_muestra = ana.id_muestra,
cod_norma_val = ana.cod_norma_val,
cod_unidad = ana.cod_unidad,
cod_acreditacion = ana.cod_acreditacion,
id_envase = ana.id_envase,
id_set = ana.id_set,
id_cartacontrol = ana.id_cartacontrol,
last_update = ana.last_update,
flag_insert = '2';
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransIngresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransIngresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransIngresos`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO biripit_pre_dw_silob.PDW_ingresos(id_ingreso,id_tipo_ingreso,id_cliente,id_dependencia,id_usuario_ingreso,id_usuario_validacion,id_factura,nro_ingreso,
raya,flag_reemplazado,flag_foto_informe,flag_carta,flag_sma,titular_proyecto,rut_titular,representante,rut_representante,proyecto,instrumentos,muestreador,
nro_requerimiento,fh_validacion,fecha_ingreso,hora_ingreso,certificacion_snp,nro_formulario_snp,cod_destino_snp,cod_categoria,lugar_descarga,f_i_muestreo,
f_muestreo,fh_almacenamiento,h_i_muestreo,h_t_muestreo,f_i_verificacion,f_t_verificacion,cont_muestreo,nro_muestreo,id_muestreador,nro_muestreo2,id_muestreador2,
cod_entrega,entidad_m,flag_limites,lugar_muestreo,envases_cliente,coleman_cliente,otros_bienes_cliente,fh_informe,flag_caudal,flag_compuesta,fh_v_destino0,
fh_s_destino0,cod_destino1,fh_i_destino1,fh_s_destino1,cod_destino2,fh_i_destino2,fh_s_destino2,cod_destino3,fh_i_destino3,fh_s_destino3,cod_destino4,
fh_i_destino4,fh_s_destino4,cod_destino5,nro_fact,fh_fact,monto_muestreo,monto_muestreo_oi,monto_analisis,flag_pagado,nro_n_credito,monto_n_credito,
file_cotizacion,transporte_envio1,nro_envio1,transporte_envio2,nro_envio2,persona_retira,contacto_retira,persona_recibe,contacto_recibe,fecha_recibe,
id_us_destino0,id_us_destino1,id_us_destino2,id_us_destino3,id_us_destino4,flag_infact,file_recepcion,estado_caja,medio_transporte,comentarios,cod_informe,
flag_prioritario,abr,flag_estado,flag_avisado,cod_rechazo,file_acta,last_update,flag_aviso_fd,flag_composito_lab,fh_preparacion_c,preparador,cantEnvases,
nro_carpeta_snp,inspector_snp,f_envio_mts,fecha_publicacion)
SELECT 
	ing.id_ingreso,
	ing.id_tipo_ingreso,
	ing.id_cliente,
	ing.id_dependencia,
	ing.id_usuario_ingreso,
	ing.id_usuario_validacion,
	ing.id_factura,
	ing.nro_ingreso,
	ing.raya,
	ing.flag_reemplazado,
	ing.flag_foto_informe,
	ing.flag_carta,
	ing.flag_sma,
	ing.titular_proyecto,
	ing.rut_titular,
	ing.representante,
	ing.rut_representante,
	ing.proyecto,
	ing.instrumentos,
	ing.muestreador,
	ing.nro_requerimiento,
	ing.fh_validacion,
	ing.fecha_ingreso,
	ing.hora_ingreso,
	ing.certificacion_snp,
	ing.nro_formulario_snp,
	ing.cod_destino_snp,
	ing.cod_categoria,
	ing.lugar_descarga,
	ing.f_i_muestreo,
	ing.f_muestreo,
	ing.fh_almacenamiento,
	ing.h_i_muestreo,
	ing.h_t_muestreo,
	ing.f_i_verificacion,
	ing.f_t_verificacion,
	ing.cont_muestreo,
	ing.nro_muestreo,
	ing.id_muestreador,
	ing.nro_muestreo2,
	ing.id_muestreador2,
	ing.cod_entrega,
	ing.entidad_m,
	ing.flag_limites,
	ing.lugar_muestreo,
	ing.envases_cliente,
	ing.coleman_cliente,
	ing.otros_bienes_cliente,
	ing.fh_informe,
	ing.flag_caudal,
	ing.flag_compuesta,
	ing.fh_v_destino0,
	ing.fh_s_destino0,
	ing.cod_destino1,
	ing.fh_i_destino1,
	ing.fh_s_destino1,
	ing.cod_destino2,
	ing.fh_i_destino2,
	ing.fh_s_destino2,
	ing.cod_destino3,
	ing.fh_i_destino3,
	ing.fh_s_destino3,
	ing.cod_destino4,
	ing.fh_i_destino4,
	ing.fh_s_destino4,
	ing.cod_destino5,
	ing.nro_fact,
	ing.fh_fact,
	ing.monto_muestreo,
	ing.monto_muestreo_oi,
	ing.monto_analisis,
	ing.flag_pagado,
	ing.nro_n_credito,
	ing.monto_n_credito,
	ing.file_cotizacion,
	ing.transporte_envio1,
	ing.nro_envio1,
	ing.transporte_envio2,
	ing.nro_envio2,
	ing.persona_retira,
	ing.contacto_retira,
	ing.persona_recibe,
	ing.contacto_recibe,
	ing.fecha_recibe,
	ing.id_us_destino0,
	ing.id_us_destino1,
	ing.id_us_destino2,
	ing.id_us_destino3,
	ing.id_us_destino4,
	ing.flag_infact,
	ing.file_recepcion,
	ing.estado_caja,
	ing.medio_transporte,
	ing.comentarios,
	ing.cod_informe,
	ing.flag_prioritario,
	ing.abr,
	ing.flag_estado,
	ing.flag_avisado,
	ing.cod_rechazo,
	ing.file_acta,
	ing.last_update,
	ing.flag_aviso_fd,
	ing.flag_composito_lab,
	ing.fh_preparacion_c,
	ing.preparador,
	ing.cantEnvases,
	ing.nro_carpeta_snp,
	ing.inspector_snp,
	ing.f_envio_mts,
	ing.fecha_publicacion
FROM
	biripit_stage_dw_silob.PDW_ingresos ing
ON DUPLICATE KEY UPDATE
  id_ingreso =ing.id_ingreso,
	id_tipo_ingreso=ing.id_tipo_ingreso,
	id_cliente=ing.id_cliente,
	id_dependencia=ing.id_dependencia,
	id_usuario_ingreso=ing.id_usuario_ingreso,
	id_usuario_validacion=ing.id_usuario_validacion,
	id_factura=ing.id_factura,
	nro_ingreso=ing.nro_ingreso,
	raya=ing.raya,
	flag_reemplazado=ing.flag_reemplazado,
	flag_foto_informe=ing.flag_foto_informe,
	flag_carta=ing.flag_carta,
	flag_sma=ing.flag_sma,
	titular_proyecto=ing.titular_proyecto,
	rut_titular=ing.rut_titular,
	representante=ing.representante,
	rut_representante=ing.rut_representante,
	proyecto=ing.proyecto,
	instrumentos=ing.instrumentos,
	muestreador=ing.muestreador,
	nro_requerimiento=ing.nro_requerimiento,
	fh_validacion=ing.fh_validacion,
	fecha_ingreso=ing.fecha_ingreso,
	hora_ingreso=ing.hora_ingreso,
	certificacion_snp=ing.certificacion_snp,
	nro_formulario_snp=ing.nro_formulario_snp,
	cod_destino_snp=ing.cod_destino_snp,
	cod_categoria=ing.cod_categoria,
	lugar_descarga=ing.lugar_descarga,
	f_i_muestreo=ing.f_i_muestreo,
	f_muestreo=ing.f_muestreo,
	fh_almacenamiento=ing.fh_almacenamiento,
	h_i_muestreo=ing.h_i_muestreo,
	h_t_muestreo=ing.h_t_muestreo,
	f_i_verificacion=ing.f_i_verificacion,
	f_t_verificacion=ing.f_t_verificacion,
	cont_muestreo=ing.cont_muestreo,
	nro_muestreo=ing.nro_muestreo,
	id_muestreador=ing.id_muestreador,
	nro_muestreo2=ing.nro_muestreo2,
	id_muestreador2=ing.id_muestreador2,
	cod_entrega=ing.cod_entrega,
	entidad_m=ing.entidad_m,
	flag_limites=ing.flag_limites,
	lugar_muestreo=ing.lugar_muestreo,
	envases_cliente=ing.envases_cliente,
	coleman_cliente=ing.coleman_cliente,
	otros_bienes_cliente=ing.otros_bienes_cliente,
	fh_informe=ing.fh_informe,
	flag_caudal=ing.flag_caudal,
	flag_compuesta=ing.flag_compuesta,
	fh_v_destino0=ing.fh_v_destino0,
	fh_s_destino0=ing.fh_s_destino0,
	cod_destino1=ing.cod_destino1,
	fh_i_destino1=ing.fh_i_destino1,
	fh_s_destino1=ing.fh_s_destino1,
	cod_destino2=ing.cod_destino2,
	fh_i_destino2=ing.fh_i_destino2,
	fh_s_destino2=ing.fh_s_destino2,
	cod_destino3=ing.cod_destino3,
	fh_i_destino3=ing.fh_i_destino3,
	fh_s_destino3=ing.fh_s_destino3,
	cod_destino4=ing.cod_destino4,
	fh_i_destino4=ing.fh_i_destino4,
	fh_s_destino4=ing.fh_s_destino4,
	cod_destino5=ing.cod_destino5,
	nro_fact=ing.nro_fact,
	fh_fact=ing.fh_fact,
	monto_muestreo=ing.monto_muestreo,
	monto_muestreo_oi=ing.monto_muestreo_oi,
	monto_analisis=ing.monto_analisis,
	flag_pagado=ing.flag_pagado,
	nro_n_credito=ing.nro_n_credito,
	monto_n_credito=ing.monto_n_credito,
	file_cotizacion=ing.file_cotizacion,
	transporte_envio1=ing.transporte_envio1,
	nro_envio1=ing.nro_envio1,
	transporte_envio2=ing.transporte_envio2,
	nro_envio2=ing.nro_envio2,
	persona_retira=ing.persona_retira,
	contacto_retira=ing.contacto_retira,
	persona_recibe=ing.persona_recibe,
	contacto_recibe=ing.contacto_recibe,
	fecha_recibe=ing.fecha_recibe,
	id_us_destino0=ing.id_us_destino0,
	id_us_destino1=ing.id_us_destino1,
	id_us_destino2=ing.id_us_destino2,
	id_us_destino3=ing.id_us_destino3,
	id_us_destino4=ing.id_us_destino4,
	flag_infact=ing.flag_infact,
	file_recepcion=ing.file_recepcion,
	estado_caja=ing.estado_caja,
	medio_transporte=ing.medio_transporte,
	comentarios=ing.comentarios,
	cod_informe=ing.cod_informe,
	flag_prioritario=ing.flag_prioritario,
	abr=ing.abr,
	flag_estado=ing.flag_estado,
	flag_avisado=ing.flag_avisado,
	cod_rechazo=ing.cod_rechazo,
	file_acta=ing.file_acta,
	last_update=ing.last_update,
	flag_aviso_fd=ing.flag_aviso_fd,
	flag_composito_lab=ing.flag_composito_lab,
	fh_preparacion_c=ing.fh_preparacion_c,
	preparador=ing.preparador,
	cantEnvases=ing.cantEnvases,
	nro_carpeta_snp=ing.nro_carpeta_snp,
	inspector_snp=ing.inspector_snp,
	f_envio_mts=ing.f_envio_mts,
	fecha_publicacion=ing.fecha_publicacion,
	flag_insert = '2';
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransMuestras
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransMuestras`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransMuestras`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO biripit_pre_dw_silob.PDW_muestras(id_muestra,identificacion,duplicado,material_id,id_ingreso,id_tipo_muestra,
clave,cod_submuestra,id_desc_prod,descripcion_muestra,cod_especie,t_ingreso,t_ingreso_error,t_corregida,id_termometro,
vol_ingreso,ph_ingreso,flag_primario,flag_secundario,flag_refrigeracion,cant_refrigerante,flag_condicion,flag_identificacion,
flag_testigo,flag_tmuestra,flag_nmuestras,flag_descripcion,flag_especie,flag_aceptado,estado_v,cod_val_resultados,n_muestras,
obs_verificacion,fh_verificacion,idus_verificacion,foto,fecha_foto,hora_caudal,caudal,formato_in,fecha_faena,fecha_elaboracion,
fecha_vencimiento,temp_muestreo,frigorifico,cod_establecimiento,pais_origen,n_cortes,n_cajas,lote,datos_camion,flag_composito,
contacto_manip,actividad_manip,seccion_manip,sala_manip,flag_cuadrante,cod_cuadrante,cod_regionh,cod_etapah,cod_consumoh,
cod_tarroh,cod_peso_exph,cod_psmbh,cod_excepcionh,flag_acta,last_update)
SELECT 
	mue.id_muestra,
	mue.identificacion,
	mue.duplicado,
	mue.material_id,
	mue.id_ingreso,
	mue.id_tipo_muestra,
	mue.clave,
	mue.cod_submuestra,
	mue.id_desc_prod,
	mue.descripcion_muestra,
	mue.cod_especie,
	mue.t_ingreso,
	mue.t_ingreso_error,
	mue.t_corregida,
	mue.id_termometro,
	mue.vol_ingreso,
	mue.ph_ingreso,
	mue.flag_primario,
	mue.flag_secundario,
	mue.flag_refrigeracion,
	mue.cant_refrigerante,
	mue.flag_condicion,
	mue.flag_identificacion,
	mue.flag_testigo,
	mue.flag_tmuestra,
	mue.flag_nmuestras,
	mue.flag_descripcion,
	mue.flag_especie,
	mue.flag_aceptado,
	mue.estado_v,
	mue.cod_val_resultados,
	mue.n_muestras,
	mue.obs_verificacion,
	mue.fh_verificacion,
	mue.idus_verificacion,
	mue.foto,
	mue.fecha_foto,
	mue.hora_caudal,
	mue.caudal,
	mue.formato_in,
	mue.fecha_faena,
	mue.fecha_elaboracion,
	mue.fecha_vencimiento,
	mue.temp_muestreo,
	mue.frigorifico,
	mue.cod_establecimiento,
	mue.pais_origen,
	mue.n_cortes,
	mue.n_cajas,
	mue.lote,
	mue.datos_camion,
	mue.flag_composito,
	mue.contacto_manip,
	mue.actividad_manip,
	mue.seccion_manip,
	mue.sala_manip,
	mue.flag_cuadrante,
	mue.cod_cuadrante,
	mue.cod_regionh,
	mue.cod_etapah,
	mue.cod_consumoh,
	mue.cod_tarroh,
	mue.cod_peso_exph,
	mue.cod_psmbh,
	mue.cod_excepcionh,
	mue.flag_acta,
	mue.last_update
FROM
	biripit_stage_dw_silob.muestras mue
ON DUPLICATE KEY UPDATE
id_muestra = mue.id_muestra,
identificacion= mue.identificacion,
duplicado	= mue.duplicado,
material_id	= mue.material_id,
id_ingreso	= mue.id_ingreso,
id_tipo_muestra= mue.id_tipo_muestra,
clave= mue.clave,
cod_submuestra	= mue.cod_submuestra,
id_desc_prod	= mue.id_desc_prod,
descripcion_muestra	= mue.descripcion_muestra,
cod_especie	= mue.cod_especie,
t_ingreso	= mue.t_ingreso,
t_ingreso_error	= mue.t_ingreso_error,
t_corregida	= mue.t_corregida,
id_termometro	= mue.id_termometro,
vol_ingreso	= mue.vol_ingreso,
ph_ingreso	= mue.ph_ingreso,
flag_primario	= mue.flag_primario,
flag_secundario	= mue.flag_secundario,
flag_refrigeracion	= mue.flag_refrigeracion,
cant_refrigerante	= mue.cant_refrigerante,
flag_condicion	= mue.flag_condicion,
flag_identificacion	= mue.flag_identificacion,
flag_testigo	= mue.flag_testigo,
flag_tmuestra	= mue.flag_tmuestra,
flag_nmuestras	= mue.flag_nmuestras,
flag_descripcion	= mue.flag_descripcion,
flag_especie	= mue.flag_especie,
flag_aceptado	= mue.flag_aceptado,
estado_v	= mue.estado_v,
cod_val_resultados	= mue.cod_val_resultados,
n_muestras	= mue.n_muestras,
obs_verificacion	= mue.obs_verificacion,
fh_verificacion	= mue.fh_verificacion,
idus_verificacion	= mue.idus_verificacion,
foto	= mue.foto,
fecha_foto	= mue.fecha_foto,
hora_caudal	= mue.hora_caudal,
caudal	= mue.caudal,
formato_in	= mue.formato_in,
fecha_faena	= mue.fecha_faena,
fecha_elaboracion	= mue.fecha_elaboracion,
fecha_vencimiento	= mue.fecha_vencimiento,
temp_muestreo	= mue.temp_muestreo,
frigorifico	= mue.frigorifico,
cod_establecimiento	= mue.cod_establecimiento,
pais_origen	= mue.pais_origen,
n_cortes	= mue.n_cortes,
n_cajas	= mue.n_cajas,
lote	= mue.lote,
datos_camion	= mue.datos_camion,
flag_composito	= mue.flag_composito,
contacto_manip	= mue.contacto_manip,
actividad_manip	= mue.actividad_manip,
seccion_manip	= mue.seccion_manip,
sala_manip	= mue.sala_manip,
flag_cuadrante	= mue.flag_cuadrante,
cod_cuadrante	= mue.cod_cuadrante,
cod_regionh	= mue.cod_regionh,
cod_etapah	= mue.cod_etapah,
cod_consumoh	= mue.cod_consumoh,
cod_tarroh	= mue.cod_tarroh,
cod_peso_exph	= mue.cod_peso_exph,
cod_psmbh	= mue.cod_psmbh,
cod_excepcionh	= mue.cod_excepcionh,
flag_acta	= mue.flag_acta,
last_update	= mue.last_update,
flag_insert	= '2';
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransReclamos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransReclamos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransReclamos`()
BEGIN
INSERT INTO biripit_pre_dw_silob.PDW_reclamos (id_reclamo,id_contacto_tecnico,ext_nombre,ext_mail,deteccion,area,descripcion,
id_ingreso_implicado,fh_abierto,fh_cierre,flag_aviso_cl,flag_justificado,justificacion,flag_implicancias,fecha_tnc,
just_implicancia,flag_ea,flag_oi,fecha_aviso_oi,id_ingreso_corregido,fecha_carta,fecha_mail,participantes,estado,observaciones,
flag_eliminado,last_update)
SELECT 
rec.id_reclamo,rec.id_contacto_tecnico,rec.ext_nombre,rec.ext_mail,rec.deteccion,rec.area,rec.descripcion,
rec.id_ingreso_implicado,rec.fh_abierto,rec.fh_cierre,rec.flag_aviso_cl,rec.flag_justificado,rec.justificacion,
rec.flag_implicancias,rec.fecha_tnc,rec.just_implicancia,rec.flag_ea,rec.flag_oi,rec.fecha_aviso_oi,rec.id_ingreso_corregido,
rec.fecha_carta,rec.fecha_mail,rec.participantes,rec.estado,rec.observaciones,rec.flag_eliminado,rec.last_update
FROM biripit_stage_dw_silob.reclamos rec
ON DUPLICATE KEY UPDATE
id_reclamo = rec.id_reclamo ,
id_contacto_tecnico = rec.id_contacto_tecnico,
ext_nombre = rec.ext_nombre,
ext_mail = rec.ext_mail,
deteccion = rec.deteccion,
area = rec.area,
descripcion = rec.descripcion,
id_ingreso_implicado = rec.id_ingreso_implicado,
fh_abierto = rec.fh_abierto,
fh_cierre = rec.fh_cierre,
flag_aviso_cl = rec.flag_aviso_cl,
flag_justificado = rec.flag_justificado,
justificacion = rec.justificacion,
flag_implicancias = rec.flag_implicancias,
fecha_tnc = rec.fecha_tnc,
just_implicancia = rec.just_implicancia,
flag_ea = rec.flag_ea,
flag_oi = rec.flag_oi,
fecha_aviso_oi = rec.fecha_aviso_oi,
id_ingreso_corregido = rec.id_ingreso_corregido,
fecha_carta = rec.fecha_carta,
fecha_mail = rec.fecha_mail,
participantes = rec.participantes,
estado = rec.estado,
observaciones = rec.observaciones,
flag_eliminado = rec.flag_eliminado,
last_update = rec.last_update,
flag_insert = '2';
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for modResAnalisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `modResAnalisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `modResAnalisis`()
BEGIN
	SET foreign_key_checks = 0;
UPDATE 
	PDW_analisis ana
LEFT JOIN PDW_tipos_analisis ta ON ta.id_tipo_analisis = ana.id_tipo_analisis
LEFT JOIN PDW_muestras mu ON mu.id_muestra = ana.id_muestra
LEFT JOIN PDW_tipos_muestras tm ON tm.id_tipo_muestra = mu.id_tipo_muestra
LEFT JOIN PDW_ingresos ing ON ing.id_ingreso = mu.id_ingreso
LEFT JOIN PDW_tipos_ingresos ti ON ti.id_tipo_ingreso = ing.id_tipo_ingreso
LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(ing.fecha_publicacion)
LEFT JOIN PDW_resumen_mensual_ingresos res ON res.WID_año = fch.WID_anho
AND res.WID_semestre = fch.WID_semestre
AND res.WID_mes = fch.WID_mes
AND res.WID_tipo_ingreso = ti.WID_tipo_ingreso
AND res.WID_tipo_muestra = tm.WID_tipo_muestra
AND res.WID_tipo_analisis = ta.WID_tipo_analisis
SET ana.WID_resumen_mensual_ingreso = res.WID_resumen_mensual_ingreso
WHERE DATE(ing.fecha_publicacion) >='2017-01-01';

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for modResEncuestas
-- ----------------------------
DROP PROCEDURE IF EXISTS `modResEncuestas`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `modResEncuestas`()
BEGIN
	SET foreign_key_checks = 0;
UPDATE 
	PDW_encuestas encu
LEFT JOIN PDW_preguntas preg ON preg.id_pregunta = encu.id_pregunta
LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(encu.fecha)
LEFT JOIN PDW_resumen_mensual_encuestas res ON res.WID_mes = fch.WID_mes AND res.WID_pregunta=preg.WID_pregunta
SET encu.WID_resumen_mensual_encuesta = res.WID_resumen_mensual_encuesta
WHERE
 encu.valor_pregunta IS NOT NULL;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for modResReclamos
-- ----------------------------
DROP PROCEDURE IF EXISTS `modResReclamos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `modResReclamos`()
BEGIN
SET foreign_key_checks = 0;
		UPDATE 
			PDW_reclamos rec

		LEFT JOIN PDW_fechas fch ON fch.fecha = rec.fh_cierre
		LEFT JOIN PDW_area ar ON ar.area = rec.area
		LEFT JOIN PDW_resumen_mensual_reclamos res ON res.WID_area = ar.WID_area
		AND res.WID_año = fch.WID_anho
		AND res.WID_mes = fch.WID_mes
SET rec.WID_resumen_mensual_reclamo = res.WID_resumen_mensual_reclamo
		WHERE rec.fh_cierre >= '2017-01-01';
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updCantResumAna
-- ----------------------------
DROP PROCEDURE IF EXISTS `updCantResumAna`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `updCantResumAna`(IN `cantidad` int,IN `wid_a` int,IN `wid_s` int,IN `wid_m` int)
BEGIN
	UPDATE PDW_resumen_mensual_ingresos  SET cant_analisis_mensual=cantidad
WHERE WID_año=wid_a AND WID_semestre=wid_s AND WID_mes=wid_m;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updCantResumInfCorr
-- ----------------------------
DROP PROCEDURE IF EXISTS `updCantResumInfCorr`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `updCantResumInfCorr`(IN `cantidad` int,IN `wid_a` int,IN `wid_s` int,IN `wid_m` int)
BEGIN
	UPDATE PDW_resumen_mensual_ingresos  SET cant_infor_corr_mensual=cantidad
WHERE WID_año=wid_a AND WID_semestre=wid_s AND WID_mes=wid_m;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updCantResumIng
-- ----------------------------
DROP PROCEDURE IF EXISTS `updCantResumIng`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `updCantResumIng`(IN `cantidad` int,IN `wid_a` int,IN `wid_s` int,IN `wid_m` int)
BEGIN
	UPDATE PDW_resumen_mensual_ingresos  SET cant_ingresos_mensual=cantidad
WHERE WID_año=wid_a AND WID_semestre=wid_s AND WID_mes=wid_m;
UPDATE PDW_resumen_mensual_ingresos  SET cant_informes_mensual=cantidad
WHERE WID_año=wid_a AND WID_semestre=wid_s AND WID_mes=wid_m;
	
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for updCantResumMue
-- ----------------------------
DROP PROCEDURE IF EXISTS `updCantResumMue`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `updCantResumMue`(IN `cantidad` int,IN `wid_a` int,IN `wid_s` int,IN `wid_m` int)
BEGIN
	UPDATE PDW_resumen_mensual_ingresos  SET cant_muestras_mensual=cantidad
WHERE WID_año=wid_a AND WID_semestre=wid_s AND WID_mes=wid_m;
END
;;
DELIMITER ;
