<?php
	/*contactos dependencias*/
	function obt_contactos_dependencias($mysqli,$mysqli2,$error){
		$sql = $mysqli->prepare("
			SELECT 
				IF(id_con_dep IS NULL,null,id_con_dep),
				IF(id_contacto_tecnico IS NULL,null,id_contacto_tecnico),
				IF(id_dependencia IS NULL,null,id_dependencia),
				IF(fecha_reg IS NULL,null,fecha_reg),
				IF(id_usuario IS NULL,null,id_usuario),
				IF(flag_vigente IS NULL,null,flag_vigente),
				IF(lastupdate IS NULL,null,lastupdate)
			FROM 
				contactos_dependencias");
		if(!$sql) echo $mysqli->error;
		$sql->bind_result($id_con_dep,$id_contacto_tecnico,$id_dependencia,$fecha_reg,$id_usuario,$flag_vigente,$lastupdate);
		$sql->execute();
		$sql->store_result();
		$valores = array();
		while($sql->fetch()){
			$actual = array();
			
			$id_con_dep=(strcmp($id_con_dep,'')==0)? 'null' : $mysqli->real_escape_string($id_con_dep);
			$id_contacto_tecnico=(strcmp($id_contacto_tecnico,'')==0)? 'null' : $mysqli->real_escape_string($id_contacto_tecnico);
			$id_dependencia=(strcmp($id_dependencia,'')==0)? 'null' : $mysqli->real_escape_string($id_dependencia);
			$fecha_reg=(strcmp($fecha_reg,'')==0)? 'null' : "'".$mysqli->real_escape_string($fecha_reg)."'";
			$id_usuario=(strcmp($id_usuario,'')==0)? 'null' : $mysqli->real_escape_string($id_usuario);
			$flag_vigente=(strcmp($flag_vigente,'')==0)? 'null' : $mysqli->real_escape_string($flag_vigente);
			$lastupdate=(strcmp($lastupdate,'')==0)? 'null' : "'".$mysqli->real_escape_string($lastupdate)."'";
			
			array_push($actual,$id_con_dep,$id_contacto_tecnico,$id_dependencia,$fecha_reg,$id_usuario,$flag_vigente,$lastupdate);
			array_push($valores,"(".implode(",",$actual).")");
		}
		$str = implode(",",$valores);
		$error = contactos_dependencias($str,$mysqli2,$error);
		return $error;
	}
	
	function contactos_dependencias($str,$mysqli2,$error){
		$mysqli2->query("SET foreign_key_checks = 0");
		$mysqli2->query("TRUNCATE TABLE contactos_dependencias");
		if(strcmp($str,'')!=0){
			$consulta = "INSERT INTO contactos_dependencias(id_con_dep,id_contacto_tecnico,id_dependencia,fecha_reg,id_usuario,flag_vigente,last_update) VALUES $str";
			$result = $mysqli2->query($consulta);
			if(!$result) $error = "contactos_dependencias: ".$mysqli2->error;
		}
		return $error;
	}
	
?>