<?php
	/*encuestas*/
	function obt_encuestas($mysqli,$mysqli2,$error){
		$sql = $mysqli->prepare("
			SELECT 
				IF(id_encuesta IS NULL,null,id_encuesta),
				IF(id_contacto IS NULL,null,id_contacto),
				IF(codigo IS NULL,null,codigo),
				IF(fecha IS NULL,null,fecha),
				IF(area IS NULL,null,area),
				IF(flag_muestreo IS NULL,null,flag_muestreo),
				IF(flag_analisis IS NULL,null,flag_analisis),
				IF(p1 IS NULL,null,p1),
				IF(p2 IS NULL,null,p2),
				IF(p3 IS NULL,null,p3),
				IF(p4 IS NULL,null,p4),
				IF(p5 IS NULL,null,p5),
				IF(p6 IS NULL,null,p6),
				IF(p7 IS NULL,null,p7),
				IF(p8 IS NULL,null,p8),
				IF(p9 IS NULL,null,p9),
				IF(mejora IS NULL,null,mejora),
				IF(observacion IS NULL,null,observacion)
			FROM 
				encuestas
			WHERE DATE(fecha)>='2017-01-01'");
		$sql->bind_result($id_encuesta,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$p1,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9,$mejora,$observacion);
		$sql->execute();
		$sql->store_result();
		$valores = array();
		while($sql->fetch()){
			$actual = array();
			$id_encuesta=(strcmp($id_encuesta,'')==0)? 'null' : $mysqli->real_escape_string($id_encuesta);
			$id_contacto=(strcmp($id_contacto,'')==0)? 'null' : $mysqli->real_escape_string($id_contacto);
			$codigo=(strcmp($codigo,'')==0)? 'null' : "'".$mysqli->real_escape_string($codigo)."'";
			$fecha=(strcmp($fecha,'')==0)? 'null' : "'".$mysqli->real_escape_string($fecha)."'";
			$area=(strcmp($area,'')==0)? 'null' : "'".$mysqli->real_escape_string($area)."'";
			$flag_muestreo=(strcmp($flag_muestreo,'')==0)? 'null' : $mysqli->real_escape_string($flag_muestreo);
			$flag_analisis=(strcmp($flag_analisis,'')==0)? 'null' : $mysqli->real_escape_string($flag_analisis);
			$p1=(strcmp($p1,'')==0)? 'null' : $mysqli->real_escape_string($p1);
			$p2=(strcmp($p2,'')==0)? 'null' : $mysqli->real_escape_string($p2);
			$p3=(strcmp($p3,'')==0)? 'null' : $mysqli->real_escape_string($p3);
			$p4=(strcmp($p4,'')==0)? 'null' : $mysqli->real_escape_string($p4);
			$p5=(strcmp($p5,'')==0)? 'null' : $mysqli->real_escape_string($p5);
			$p6=(strcmp($p6,'')==0)? 'null' : $mysqli->real_escape_string($p6);
			$p7=(strcmp($p7,'')==0)? 'null' : $mysqli->real_escape_string($p7);
			$p8=(strcmp($p8,'')==0)? 'null' : $mysqli->real_escape_string($p8);
			$p9=(strcmp($p9,'')==0)? 'null' : $mysqli->real_escape_string($p9);
			$mejora=(strcmp($mejora,'')==0)? 'null' : "'".$mysqli->real_escape_string($mejora)."'";
			$observacion=(strcmp($observacion,'')==0)? 'null' : "'".$mysqli->real_escape_string($observacion)."'";
			
			
			array_push($actual,$id_encuesta,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$p1,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9,$mejora,$observacion);
			array_push($valores,"(".implode(",",$actual).")");
		}
		$str = implode(",",$valores);
		$error = encuestas($str,$mysqli2,$error);
		return $error;
	}
	
	function encuestas($str,$mysqli2,$error){
		$mysqli2->query("SET foreign_key_checks = 0");
		$mysqli2->query("TRUNCATE TABLE encuestas");
		if(strcmp($str,'')!=0){
			
			$consulta = "INSERT INTO encuestas(id_encuesta,id_contacto,codigo,fecha,area,flag_muestreo,flag_analisis,p1,p2,p3,p4,p5,p6,p7,p8,p9,mejora,observacion) VALUES $str";
			$result = $mysqli2->query($consulta);
			if(!$result) $error = "encuestas: ".$mysqli2->error;
			return $error;
		}
	}
?>